//LidScrewHeads.scad;

//This is version 2022_03_11;
//Previous versions used a separate, 
//trivial file: ScrewHead.scad to generate 
//the cylinder for the screw head;
//That was confusing and for this version, 
//the cylinder is generated 
//within this module;

//The screw heads are generated as objects 
//to be used with difference() commands 
//to create holes into which the screw heads 
//are recessed;

//The holes are normally created on 
//the underside of a floor 
//resting on the XY plane;

//The calling module is responsible 
//for any other placement;

//For screw heads, 
//the hole depth is usually precise;
//For screw threads, it is often generous; 

include <BATT_Dimensions.scad>

module LidScrewHeads(HolePhi, HoleDepth)
{

//HolePhi = 4;
//HoleDepth = 2;
    
echo("Begin LidScrewHeads");
    
//DeltaZ is constant for all screws;
DeltaZ = HoleDepth/2 -Fuzz;

//I need four screw heads;
//echo("HeadBL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("HeadBR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("HeadTR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

//echo("HeadTL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
cylinder(h=HoleDepth,
    d=HolePhi, center=true, $fn=32);

}
//
